function Y = multiskewh(X)
% Returns the skew-Hermitian parts of the matrices in the 3D matrix X.
%
% function Y = multiskewh(X)
%
% Y is a 3D matrix the same size as X. Each slice Y(:, :, i) is the
% skew-Hermitian part of the slice X(:, :, i).
%
% See also: multiskew multiprod multitransp multiscale multisym

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, June 18, 2019.
% Contributors: 
% Change log: 

    Y = .5*(X - multihconj(X));
    
end
