%{
Refrence:

''Zeng X, Fang J, Wang B, et al. CSI-Free Position Optimization 
for Movable Antenna Communication Systems: A Black-Box Optimization 
Approach[J]. IEEE Wireless Communications Letters, 2024. ''
Function: ZO-AdaMM-final
Date: Nov./2024
Author: Xianlong Zeng

%}

clear
close all
clc

%% The received SNR vs the number of sample
% parameter setting
Nt=1; 
Nr=1;
f_c=5e9;% frequence
c=3e8;% light speed
d=2;
lambda=c/f_c;% 
A=4*lambda;% movable region
eta=0.0005; % step size
h=0.125*lambda;
Pt=30;% dBm
Pt=(1e-3)*10^(Pt/10);% transmit power
L=30;
L_r=L; %recieve paths
L_t=L; %transmit paths
r_loc=zeros(Nt,2); % initial location of recieve antenna
t_loc=zeros(Nr,2); % initial location of transmit antenna
counter=0;
M_tot=30:5:150;
G_tot=4:1:6;
n_M=length(M_tot);
iter_max=1e3;
SNR_perfert=zeros(n_M,iter_max);
SNR_ZO_est=zeros(n_M,iter_max);
err_to=zeros(n_M,iter_max);
for iter=1:iter_max
 %% generate channel
        path_am_diag=sqrt(1/2)*(1/(2*L_r))*(randn(L_r,1)+1j*randn(L_t,1));
        path_am=diag(path_am_diag);
        for il=1:L_r
            for ilt=1:L_t
                if il~=ilt
                    path_am(il,ilt)=0;%sqrt(1/2)*(1/(10*L_r*2))*(randn(1,1)+1j*randn(1,1));
                end
            end
        end
        theta_az_r=rand(L_r,1)*pi-pi/2;%[-pi/4,pi/6,pi/3,-pi/5].';%
        theta_ez_r=rand(L_r,1)*pi-pi/2;%[-pi/6,pi/4,pi/3,-pi/5].';%
        theta_r=[theta_az_r,theta_ez_r];
        theta_r_true=[cos(theta_az_r).*sin(theta_ez_r),sin(theta_az_r)];
        theta_az_t=rand(L_t,1)*pi-pi/2;%[-pi/5,pi/5,pi/6,-pi/3].';%
        theta_ez_t=rand(L_t,1)*pi-pi/2;%[-pi/6,pi/4,pi/3,-pi/3].';%
        theta_t=[theta_az_t,theta_ez_t];
        theta_t_true=[cos(theta_az_t).*sin(theta_ez_t),sin(theta_az_t)];
        phase_loc= @(x,phi) (2*pi/lambda)*(x(:,1)*cos(phi(:,1).').*sin(phi(:,2).')+x(:,2)*sin(phi(:,1).'));
        % generata  over-complete matrix according to the transceiver location
        G=2e2;
        theta_g=linspace(-1,1-2/G,G);
        [theta1,theta2]=meshgrid(theta_g.',theta_g.');
        theta=[theta1(:),theta2(:)];
        phase_loc_fo= @(x,theta) (2*pi/lambda)*(x(:,1)*theta(:,1).'+x(:,2)*theta(:,2).');

    for im=1:n_M
      
        %initial SNR
        SNR=40;
        sigma_2=Pt*10^(-SNR/10);
        sigma=sqrt(sigma_2);
        
        %reference signal
        rou_r0=phase_loc(r_loc,theta_r);
        rou_t0=phase_loc(t_loc,theta_t);
        phase_r0=exp(1j*rou_r0).';
        phase_t0=exp(1j*rou_t0).';
        hp_0=sqrt(Pt)*phase_r0'*(path_am)*phase_t0;
        M1=M_tot(im);
        M=M1; 
        t_loc_test=(A)*rand(M,2)-A/2;
        D_complete=exp(-1j*phase_loc_fo(t_loc_test,theta));
        x_grid1=linspace(-2*lambda,2*lambda,2e2);
        y_grid1=linspace(-2*lambda,2*lambda,2e2);
        h_map=zeros(2e2);
        for ix=1:2e2
            for iy=1:2e2
                rou_r_map=phase_loc([x_grid1(ix),y_grid1(iy)],theta_r);
                phase_r_map=exp(1j*rou_r_map).';
                h_map(ix,iy)=abs(phase_r_map'*(path_am)*phase_t0)^2;
            end
        end
        h_1=max(max(h_map));
        [real_az,real_ez]=find(h_map==h_1);
        SNR1=10*log10(h_1/sigma_2);
        %ZO_ADAMM campare
         if im>=4
         itp=3;
         else
             itp=im;
         end
         G_rand=G_tot(itp);
         h_map_test=zeros(G_rand);
         x_grid2=linspace(-2*lambda,2*lambda,G_rand+1);
         y_grid2=linspace(-2*lambda,2*lambda,G_rand+1);
         grid1=x_grid2(1)-x_grid2(2);
         x_grid_est=x_grid2(1:G_rand)-rand(1,G_rand)*grid1;
         y_grid_est=y_grid2(1:G_rand)-rand(1,G_rand)*grid1;
         for ix=1: G_rand
             for iy=1: G_rand
                 rou_r_map=phase_loc([x_grid_est(ix),y_grid_est(iy)],theta_r);
                 phase_r_map=exp(1j*rou_r_map).';
                 h_map_test(ix,iy)=abs(phase_r_map'*(path_am)*phase_t0)^2;
             end
         end
        [x_est_1,y_est_1]=find(h_map_test==max(max(h_map_test)));
        r_loc_rand=[x_grid_est(x_est_1);y_grid_est(y_est_1)];%+0.01*lambda*randn(2,1);%A*rand(2,1)-A/2;%
        [ hpi_ADAM,loc_r_new_ADAM,T]=ZO_ADAM_0711(d,eta,h,r_loc_rand-0.01,theta_r,sigma,path_am,L,lambda,A);
        if T>=2*M- G_rand^2
            h3= hpi_ADAM(round((2*M- G_rand^2)/2));
        else
            h3=hpi_ADAM(T+1) ;
        end
        SNR3=10*log10(h3/sigma_2);
        SNR_perfert(im,iter)=SNR1;
        SNR_ZO_est(im,iter)=SNR3;
        clc
        counter=counter+1;
        fprintf('Progress:%.2f%%\n',counter/((n_M)*iter_max)*100)
    end
end
SNR_0=10*log10(abs(hp_0)^2/sigma_2);
SNR_P=mean(SNR_perfert,2);%y_est_1
figure
plot([0 (M_tot)*2],[SNR_P(1);mean(SNR_perfert,2)],'o-','linewidth',1.5,'markersize',5); hold on
plot([0,(M_tot)*2],[SNR_0;mean(SNR_ZO_est,2)],'+-','linewidth',1.5,'markersize',5); hold on%10*log10(hpi_ADAM(20)/sigma_2);
xlabel('the number of measurements','Interpreter','latex','FontSize',14)
ylabel('achievable SNR','Interpreter','latex','FontSize',14)
grid on


